﻿namespace Microsoft.Samples.PlanMyNight.Web.Helpers.Tests
{
    using System;
    using System.Web.Routing;
    using Microsoft.Samples.PlanMyNight.Entities;
    using Microsoft.Samples.PlanMyNight.Web.Controllers;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;
    using MvcContrib.TestHelper;

    [TestClass]
    public class RoutesFixture
    {
        [TestInitialize]
        public void SetupRoutes()
        {
            RouteTable.Routes.Clear();
            RoutingManager.RegisterRoutes(RouteTable.Routes);
        }

        // Search
        [TestMethod]
        public void UrlMapsToSearchIndex()
        {
            "~/".ShouldMapTo<SearchController>(c => c.Index());
        }

        [TestMethod]
        public void UrlMapsToSearchQuery()
        {
            "~/Search/Advanced/?ActivityTypeId=0&StreetAddress=&City=&State=&Zip=&Radius=0&resultType=1&SortBy=".ShouldMapTo<SearchController>(c => c.Advanced(It.IsAny<AdvancedSearchQuery>()));
        }

        // Account
        [TestMethod]
        public void UrlMapsToLiveId()
        {
            "~/Account/LiveId".ShouldMapTo<AccountController>(c => c.LiveId());
        }

        [TestMethod]
        public void UrlMapsToLogin()
        {
            "~/Account/Login".ShouldMapTo<AccountController>(c => c.Login(null));
        }

        [TestMethod]
        public void UrlMapsToProfile()
        {
            "~/Account".ShouldMapTo<AccountController>(c => c.Index(null));
        }

        [TestMethod]
        public void UrlMapsToUpdateProfile()
        {
            "~/Account/Update".ShouldMapTo<AccountController>(c => c.Update(It.IsAny<UserProfile>()));
        }

        [TestMethod]
        public void UrlMapsToUpdateProfileSuccess()
        {
            "~/Account/UpdateSuccess".ShouldMapTo<AccountController>(c => c.UpdateSuccess(null));
        }

        // Itineraries
        [TestMethod]
        public void UrlMapsToItineraryDetails()
        {
            "~/Itineraries/1".ShouldMapTo<ItinerariesController>(c => c.Details(1));
        }

        [TestMethod]
        public void UrlMapsToItineraryEdit()
        {
            "~/Itineraries/Edit/1".ShouldMapTo<ItinerariesController>(c => c.Edit(1));
        }

        [TestMethod]
        public void UrlMapsToMyItineraries()
        {
            "~/Itineraries".ShouldMapTo<ItinerariesController>(c => c.Index());
        }

        [TestMethod]
        public void UrlMapsToItinerariesByUser()
        {
            "~/Itineraries/ByUser/00000000-0000-0000-0000-000000000000".ShouldMapTo<ItinerariesController>(c => c.ByUser(Guid.Empty));
        }

        [TestMethod]
        public void UrlMapsToCurrentItineraryDetails()
        {
            "~/Itineraries/Current".ShouldMapTo<ItinerariesController>(c => c.Current());
        }

        [TestMethod]
        public void UrlMapsToNewItinerary()
        {
            "~/Itineraries/New".ShouldMapTo<ItinerariesController>(c => c.New());
        }

        [TestMethod]
        public void UrlMapsToSaveItinerary()
        {
            "~/Itineraries/Save".ShouldMapTo<ItinerariesController>(c => c.Save(null, null, null));
        }

        // Sitemap
        ////[TestMethod]
        ////public void UrlMapsToSitemap()
        ////{
        ////    "~/sitemap.xml".ShouldMapTo<SitemapController>(c => c.Index());
        ////}
    }
}
